(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     25065,        817]*)
(*NotebookOutlinePosition[     39010,       1158]*)
(*  CellTagsIndexPosition[     37960,       1125]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style", "Command",
  CellTags->"MenuListStyles"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Style", "SR"],
  " assigns the specified style to the selected cell or text."
}], "Usage",
  CellTags->"MenuListStyles"],

Cell[TextData[{
  "\[FilledSmallSquare] To assign a style to one or more cells, select the \
cells and then choose the desired style name from the ",
  StyleBox["Style", "SR"],
  " submenu."
}], "Notes",
  CellTags->"MenuListStyles"],

Cell[TextData[{
  "\[FilledSmallSquare] The cell styles listed in the Style submenu are \
defined in the style sheet assigned to your current notebook.",
  StyleBox[" Mathematica",
    FontSlant->"Italic"],
  " assigns a default style sheet called DefaultStyles to new notebooks. \n\
\[FilledSmallSquare] Styles can also be assigned to individual words or \
characters."
}], "Notes",
  CellTags->"MenuListStyles"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  " and ",
  ButtonBox["Edit Style Sheet",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"MenuListStyles"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Other...", "SR"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "dialog box lets you type in a style name to be assigned to the selected \
cell or text (not all styles defined in a style sheet need be listed in the \
Styles menu). Note that you can also assign cell options by typing the option \
setting in this dialog box. "
}], "Notes",
  CellTags->"otherStyleNameDialogID"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Screen Style Environment", "Command",
  CellTags->"MenuListScreenStyleEnvironments"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Screen Style Environment", "SR"],
  " determines which style environment to use for onscreen display."
}], "Usage",
  CellTags->"MenuListScreenStyleEnvironments"],

Cell[TextData[{
  "\[FilledSmallSquare] Notebook style sheets typically contain separate \
style definitions for printed versus onscreen formatting. There can be \
several screen environments: for example, one for \"working\" and one for \
giving a \"presentation\".\n\[FilledSmallSquare] This command sets the option \
",
  StyleBox["ScreenStyleEnvironment", "MR"],
  " on the selected notebook."
}], "Notes",
  CellTags->"MenuListScreenStyleEnvironments"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Printing Style Environment", "Command",
  CellTags->"MenuListPrintingStyleEnvironments"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Printing Style Environment", "SR"],
  " determines which style environment to use for printing."
}], "Usage",
  CellTags->"MenuListPrintingStyleEnvironments"],

Cell[TextData[{
  "\[FilledSmallSquare] Notebook style sheets typically contain separate \
style definitions for printed versus onscreen formatting. \n\
\[FilledSmallSquare] This command sets the option ",
  StyleBox["PrintingStyleEnvironment", "MR"],
  " on the selected notebook."
}], "Notes",
  CellTags->"MenuListPrintingStyleEnvironments"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show Expression", "Command",
  CellTags->"ToggleShowExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show Expression", "SR"],
  " toggles between expression and displayed form of a cell."
}], "Usage",
  CellTags->"ToggleShowExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] In expression form, you are seeing the underlying ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression as it would saved in a file.\n\[FilledSmallSquare] You can \
edit the cell in either expression or display form, and when you toggle the \
form, the changes will be reflected in the other form.\n\[FilledSmallSquare] \
When editing in expression form, you must be careful to enter only \
syntactically correct expressions. If there is an error in the expression \
when you toggle back to display form, it will be reported, and the offending \
part of the expression will be selected."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ToggleShowExpression"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["E", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["E", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["E", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"ToggleShowExpression"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Style Sheet", "Command",
  CellTags->"MenuStyleSheet"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Style Sheet ", "SR"],
  " assigns the specified style sheet to the current notebook. "
}], "Usage",
  CellTags->"MenuStyleSheet"],

Cell[TextData[
"\[FilledSmallSquare] A check appears beside the style sheet currently \
assigned to the notebook."], "Notes",
  AspectRatioFixed->False,
  CellTags->"MenuStyleSheet"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " standard style notebooks are kept in SystemFiles/FrontEnd/StyleSheets. \
Style notebooks created by users can be put in \
Configuration/FrontEnd/StyleSheets.  Any style notebooks in these directories \
will automatically be listed in the Style Sheets submenu."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"MenuStyleSheet"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Other ", "SR"],
  "command opens a dialog box to  find style sheets not listed in the Style \
Sheet submenu.\n\[FilledSmallSquare] The commands in this submenu set the \
option ",
  StyleBox["StyleDefinitions", "MR"],
  " on the selected notebook."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"MenuStyleSheet"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Edit Style Sheet...", "Command",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Edit Style Sheet", "SR"],
  " lets you edit the style definitions for the current notebook."
}], "Usage",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell[TextData[
"\[FilledSmallSquare] Open the style sheet, and modify the cell styles you \
want to change. Style changes will be reflected in all notebooks that use the \
style sheet.\n\[FilledSmallSquare] If the notebook is using a shared style \
sheet, a dialog box will appear giving the following choices:"], "Notes",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell[TextData[StyleBox["Import Private Copy",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell["\<\
Copies the settings from the shared style sheet to a private style \
sheet just for this notebook.  Any changed made to the style sheet will only \
effect this notebook.\
\>", "IndentedText",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell[TextData[StyleBox["Edit Shared Style Sheet",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],

Cell["\<\
Opens the shared version of the style sheet.  Any changes will \
affect all notebooks that refer to this style sheet.\
\>", "IndentedText",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Option Inspector", "Command",
  CellTags->{"OptionsDialog", "styleInspectorDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Option Inspector", "SR"],
  " lets you view and set all option values for cells, notebooks, and global \
preferences."
}], "Usage",
  CellTags->{"OptionsDialog", "styleInspectorDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts: ",
  StyleBox["\[ShiftKey]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["O", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["O", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["O", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}]
}, Open  ]],

Cell[TextData[
"\[FilledSmallSquare] The first pop-up menu (labeled Show Option Values For) \
lists \"global\", \"notebook\", \"selection's style\" and \"selection\". This \
menu chooses the scope in which your options will take effect. Some options \
are dimmed when they do not apply to the scope you have chosen."], "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["Global", "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["Sets options for the front end generally.", "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["Notebook", "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["Sets options for the whole notebook.", "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["Selection's style", "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["\<\
Sets options in the notebook's style sheet. For example, if you have selected \
a cell having the Input style, and the notebook is using the Defaul style \
sheet, the options you set will change the definition of the Input style in \
the Default style sheet.\
\>", "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["Selection", "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["\<\
Sets options for the selected cells or for characters in a \
cell.\
\>", "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[TextData[
"\[FilledSmallSquare] The second pop-up menu lists options \"by category\", \
\"alphabetically\", and \"by text\"."], "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[TextData[
"\[FilledSmallSquare] The \"Lookup\" box finds the option you type in."], 
  "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[TextData[{
  StyleBox["1.",
    FontWeight->"Bold"],
  "  ",
  "Enter an option name, or part of its name."
}], "ItemizedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[TextData[{
  StyleBox["2.",
    FontWeight->"Bold"],
  "  Click Lookup, or press Return."
}], "ItemizedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell["\<\
The Option Inspector goes to the first matching option. Click \
Lookup or press Return again to go to the next match.\
\>", "NotesList",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[TextData[
"\[FilledSmallSquare] Each line in the list of options gives the option name, \
followed by its current value. Change the option's value by choosing from the \
pop-up menu at the right, or by selecting the value itself and typing over \
it. A symbol in front of the option name indicates that the listed option and \
its value is set in the selected character, cell, style or notebook."], 
  "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[CellGroupData[{

Cell["Remove Options", "Command",
  CellTags->"ClearCellOptions"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Remove Options", "SR"],
  " removes all explicit option settings for the selected cell."
}], "Usage",
  CellTags->"ClearCellOptions"],

Cell[TextData[
"\[FilledSmallSquare] This can be used to uniformly impose the cell's style \
on the cell contents."], "Notes",
  CellTags->"ClearCellOptions"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Font", "Command",
  CellTags->"MenuListFonts"],

Cell[TextData[
"\[FilledSmallSquare] This menu lists all fonts currently installed in your \
computer system."], "Usage",
  CellTags->"MenuListFonts"],

Cell[TextData[{
  "\[FilledSmallSquare] A check beside a font name means that the selected \
characters or cells use that font.\n\[FilledSmallSquare] The commands in this \
submenu set the option ",
  StyleBox["FontFamily", "MR"],
  " on the selected Cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"MenuListFonts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Font Panel", "Command",
  CellTags->"NeXTFonts"],

Cell[TextData[
"\[FilledSmallSquare] This command brings up the standard NEXTSTEP font \
panel. (NeXT)"], "Usage",
  CellTags->"NeXTFonts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Face", "Command",
  CellTags->"PlainFont"],

Cell[TextData[
"\[FilledSmallSquare] This submenu lists available font face variations \
(bold, italic, underline, etc)."], "Usage",
  CellTags->"PlainFont"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The commands in this submenu set the options ",
  StyleBox["FontWeight", "MR"],
  ", ",
  StyleBox["FontSlant", "MR"],
  ", ",
  StyleBox["FontTracking", "MR"],
  ", and ",
  StyleBox["FontVariations", "MR"],
  " on the selected Cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"PlainFont"],

Cell[CellGroupData[{

Cell["Size", "Command",
  CellTags->"FontSize"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Size", "SR"],
  " assigns the specified point size to the selected text."
}], "Usage",
  CellTags->"FontSize"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The commands in this submenu set the option ",
  StyleBox["FontSize", "MR"],
  " on the selected Cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"FontSize"],

Cell[CellGroupData[{

Cell["Text Color", "Command",
  CellTags->"FontColor"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Text Color", "SR"],
  " assigns the specified color to the selected text."
}], "Usage",
  CellTags->"FontColor"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The commands in this submenu set the option ",
  StyleBox["FontColor", "MR"],
  " on the selected Cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"FontColor"],

Cell[CellGroupData[{

Cell["Background Color", "Command",
  CellTags->"BackGround"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Background Color", "SR"],
  " assigns the specified background color to the cell."
}], "Usage",
  CellTags->"BackGround"],

Cell[TextData[{
  "\[FilledSmallSquare] \"Gray Box\" puts a cell frame around the cell with a \
light gray background.  This command is setting a combination of the ",
  StyleBox["CellFrame", "MR"],
  " and ",
  StyleBox["Background", "MR"],
  " options.\n\[FilledSmallSquare] The commands in this submenu set the \
option ",
  StyleBox["Background", "MR"],
  " on the selected Cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"BackGround"],

Cell[TextData[{
  "\[FilledSmallSquare] See Reference Guide: ",
  ButtonBox["CellFrame",
    ButtonStyle->"RefGuideLink"],
  "."
}], "Notes",
  CellTags->"BackGround"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Text Alignment", "Command",
  CellTags->"TextAlignment"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Text Alignment", "SR"],
  " assigns the specified text alignment to the selected cell."
}], "Usage",
  CellTags->"TextAlignment"],

Cell[TextData[{
  "\[FilledSmallSquare] Alignment can be at any point along the width of each \
line of text, specified by a percentage: 25% is roughly in between \
left-aligned and centered, while 75% is roughly in between centered and \
right-aligned.  Other alignment points can be specified using the",
  StyleBox[" Option Inspector", "MR"],
  ".\n\[FilledSmallSquare] The commands in this submenu set the option ",
  StyleBox["TextAlignment", "MR"],
  " on the selected Cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"TextAlignment"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Text Justification", "Command",
  CellTags->"TextJustification"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Text Justification", "SR"],
  " controls justification (word spacing) of wordwrapped cells."
}], "Usage",
  CellTags->"TextJustification"],

Cell[TextData[
"\[FilledSmallSquare] \"Natural spacing\" introduces no additional spacing, \
resulting in ragged margins."], "Notes",
  CellTags->"TextJustification"],

Cell[TextData[
"\[FilledSmallSquare] \"Full Justification\" introduces enough additional \
spacing to each line to make it fill the full width of the column, resulting \
in flush margins.  This is a commonly used style, but results in hard-to-read \
text."], "Notes",
  CellTags->"TextJustification"],

Cell[TextData[{
  "\[FilledSmallSquare] The other justification settings apply varying \
degrees of justification, resulting in less-ragged, but not fully flush \
margins.\n\[FilledSmallSquare] The commands in this submenu set the option ",
  StyleBox["TextJustification", "MR"],
  " on the selected Cell object(s) or on text within a cell."
}], "Notes",
  CellTags->"TextJustification"]
}, Open  ]],

Cell[TextData[{
  "Word Wrapping ",
  StyleBox["submenu",
    FontWeight->"Plain"]
}], "Section"],

Cell[CellGroupData[{

Cell["Don't Word Wrap", "Command",
  CellTags->"PageWidthDon't"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Don't Word Wrap", "SR"],
  " turns word wrapping off."
}], "Usage",
  CellTags->"PageWidthDon't"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] This command sets the option ",
  StyleBox["PageWidth\[Rule]Infinity", "MR"],
  " on the selected Cell object(s)."
}], "Notes",
  CellTags->"PageWidthDon't"],

Cell[CellGroupData[{

Cell["Wrap at Paper Width", "Command",
  CellTags->"PageWidthPaper"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Wrap at Paper Width", "SR"],
  " wraps lines at the width of the paper currently specified by the printing \
(Page Setup) settings."
}], "Usage",
  CellTags->"PageWidthPaper"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] This setting is normally used in the Printout style \
environment to make text fit the printed page.\n\[FilledSmallSquare] This \
command sets the option ",
  StyleBox["PageWidth\[Rule]PaperWidth", "MR"],
  " on the selected Cell object(s)."
}], "Notes",
  CellTags->"PageWidthPaper"],

Cell[CellGroupData[{

Cell["Wrap at Window Width", "Command",
  CellTags->"PageWidthWindow"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Wrap at Window Width", "SR"],
  " wraps lines at the width of the window containing the text."
}], "Usage",
  CellTags->"PageWidthWindow"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] This setting is normally used in the Working style \
environment to make text fit the current window width.\n\[FilledSmallSquare] \
This command sets the option ",
  StyleBox["PageWidth\[Rule]WindowWidth", "MR"],
  " on the selected Cell object(s)."
}], "Notes",
  CellTags->"PageWidthWindow"],

Cell[CellGroupData[{

Cell["Fixed Word Wrap Width", "Command",
  CellTags->"PageWidthFixed"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Fixed Word Wrap Width", "SR"],
  " locks down the current wordwrapping width so it won't change when you \
resize the window or change paper width."
}], "Usage",
  CellTags->"PageWidthFixed"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The wrapping width can also be adjusted manually \
using the Ruler.\n\[FilledSmallSquare] This command sets the option ",
  StyleBox["PageWidth", "MR"],
  " on the selected Cell object(s)."
}], "Notes",
  CellTags->"PageWidthFixed"],

Cell[CellGroupData[{

Cell["Cell Dingbat", "Command",
  CellTags->"CellDingbat"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Cell Dingbat", "SR"],
  " attaches the specified character as a left-hanging dingbat on the \
selected cell(s)."
}], "Usage",
  CellTags->"CellDingbat"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The dingbat can be specified for a style and will \
then be displayed by all cells in that style.\n\[FilledSmallSquare] This \
command sets the option ",
  StyleBox["CellDingbat", "MR"],
  " on the selected Cell object(s)."
}], "Notes",
  CellTags->"CellDingbat"],

Cell[CellGroupData[{

Cell["Show Ruler", "Command",
  CellTags->"RulerBar"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show Ruler", "SR"],
  " toggles the display of the ruler along the top of the notebook."
}], "Usage",
  CellTags->"RulerBar"],

Cell[TextData[{
  "\[FilledSmallSquare] Use the ruler to set the text margins of selected \
cells, and set the indentation of cell names and keywords.\n\
\[FilledSmallSquare] This command sets the option ",
  StyleBox["WindowToolbars\[Rule]{\"RulerBar\"}", "MR"],
  " on the selected notebook."
}], "Notes",
  CellTags->"RulerBar"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show Toolbar", "Command",
  CellTags->"EditBar"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show Toolbar", "SR"],
  " toggles the display of the toolbar along the top of the notebook."
}], "Usage",
  TextJustification->0,
  CellTags->"EditBar"],

Cell[TextData[{
  "\[FilledSmallSquare] The toolbar displays the cell style of the selected \
cell, and allows you to choose other cell styles. You can also use the \
toolbar  to change the text alignment within a cell to flush left, centered,  \
flush right,  or justified.\n\[FilledSmallSquare] This command sets the \
option ",
  StyleBox["WindowToolbars\[Rule]{\"EditBar\"}", "MR"],
  " on the selected notebook."
}], "Notes",
  TextJustification->0,
  CellTags->"EditBar"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Show Page Breaks", "Command",
  CellTags->"ShowPageBreaks"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Show Page Breaks", "SR"],
  " calculates and displays page breaks on screen."
}], "Usage",
  CellTags->"ShowPageBreaks"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Page breaks that fall between cells are shown with a \
dashed line across the entire width of the window.  Page breaks that fall \
inside a cell are shown by a dashed line over the width of the cell bracket.\n\
\[FilledSmallSquare] This command toggles the option ",
  StyleBox["ShowPageBreaks", "MR"],
  " between ",
  StyleBox["True", "MR"],
  " and ",
  StyleBox["False", "MR"],
  " on the selected notebook."
}], "Notes",
  TextJustification->0,
  CellTags->"ShowPageBreaks"],

Cell[CellGroupData[{

Cell["Magnification", "Command",
  CellTags->"Magnification"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Magnification", "SR"],
  " changes the magnification of the notebook's contents."
}], "Usage",
  CellTags->"Magnification"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] The magnification setting does not affect the size of \
printed output.\n\[FilledSmallSquare] In many situtations, using the \
Presentation style environment is a better way of making text larger overall.\
\n\[FilledSmallSquare] This command sets the option ",
  StyleBox["Magnification", "MR"],
  " on the selected notebook."
}], "Notes",
  TextJustification->0,
  CellTags->"Magnification"]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{588, 316},
WindowMargins->{{5, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "MenuListStyles"->{
    Cell[1731, 51, 54, 1, 34, "Command",
      CellTags->"MenuListStyles"],
    Cell[1788, 54, 175, 5, 29, "Usage",
      CellTags->"MenuListStyles"],
    Cell[1966, 61, 233, 6, 36, "Notes",
      CellTags->"MenuListStyles"],
    Cell[2202, 69, 413, 9, 56, "Notes",
      CellTags->"MenuListStyles"],
    Cell[2618, 80, 250, 9, 22, "Notes",
      CellTags->"MenuListStyles"]},
  "otherStyleNameDialogID"->{
    Cell[2871, 91, 433, 10, 50, "Notes",
      CellTags->"otherStyleNameDialogID"]},
  "MenuListScreenStyleEnvironments"->{
    Cell[3341, 106, 90, 1, 34, "Command",
      CellTags->"MenuListScreenStyleEnvironments"],
    Cell[3434, 109, 217, 5, 29, "Usage",
      CellTags->"MenuListScreenStyleEnvironments"],
    Cell[3654, 116, 457, 9, 56, "Notes",
      CellTags->"MenuListScreenStyleEnvironments"]},
  "MenuListPrintingStyleEnvironments"->{
    Cell[4148, 130, 94, 1, 34, "Command",
      CellTags->"MenuListPrintingStyleEnvironments"],
    Cell[4245, 133, 213, 5, 29, "Usage",
      CellTags->"MenuListPrintingStyleEnvironments"],
    Cell[4461, 140, 344, 7, 42, "Notes",
      CellTags->"MenuListPrintingStyleEnvironments"]},
  "ToggleShowExpression"->{
    Cell[4842, 152, 70, 1, 34, "Command",
      CellTags->"ToggleShowExpression"],
    Cell[4915, 155, 190, 5, 29, "Usage",
      CellTags->"ToggleShowExpression"],
    Cell[5108, 162, 719, 13, 104, "Notes",
      CellTags->"ToggleShowExpression"],
    Cell[5830, 177, 658, 18, 22, "Notes",
      CellTags->"ToggleShowExpression"]},
  "MenuStyleSheet"->{
    Cell[6525, 200, 60, 1, 34, "Command",
      CellTags->"MenuStyleSheet"],
    Cell[6588, 203, 184, 5, 29, "Usage",
      CellTags->"MenuStyleSheet"],
    Cell[6775, 210, 182, 4, 22, "Notes",
      CellTags->"MenuStyleSheet"],
    Cell[6960, 216, 429, 10, 50, "Notes",
      CellTags->"MenuStyleSheet"],
    Cell[7392, 228, 377, 10, 42, "Notes",
      CellTags->"MenuStyleSheet"]},
  "EditStyleDefinitions"->{
    Cell[7806, 243, 105, 1, 34, "Command",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[7914, 246, 227, 5, 29, "Usage",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8144, 253, 389, 5, 56, "Notes",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8536, 260, 150, 2, 25, "DialogItem",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8689, 264, 268, 5, 34, "IndentedText",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8960, 271, 154, 2, 25, "DialogItem",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[9117, 275, 216, 4, 20, "IndentedText",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}]},
  "editingSharedStyleSheetID"->{
    Cell[7806, 243, 105, 1, 34, "Command",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[7914, 246, 227, 5, 29, "Usage",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8144, 253, 389, 5, 56, "Notes",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8536, 260, 150, 2, 25, "DialogItem",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8689, 264, 268, 5, 34, "IndentedText",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[8960, 271, 154, 2, 25, "DialogItem",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
    Cell[9117, 275, 216, 4, 20, "IndentedText",
      CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}]},
  "OptionsDialog"->{
    Cell[9370, 284, 92, 1, 34, "Command",
      CellTags->{"OptionsDialog", "styleInspectorDialogID"}],
    Cell[9465, 287, 247, 6, 29, "Usage",
      CellTags->{"OptionsDialog", "styleInspectorDialogID"}],
    Cell[9715, 295, 679, 18, 22, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10409, 316, 384, 5, 50, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10796, 323, 85, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10884, 326, 122, 1, 20, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11009, 329, 87, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11099, 332, 117, 1, 20, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11219, 335, 96, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11318, 338, 347, 6, 48, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11668, 346, 88, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11759, 349, 155, 4, 20, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11917, 355, 198, 3, 22, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12118, 360, 157, 3, 22, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12278, 365, 189, 6, 22, "ItemizedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12470, 373, 171, 5, 22, "ItemizedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12644, 380, 203, 4, 38, "NotesList",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12850, 386, 472, 7, 64, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}]},
  "styleInspectorDialogID"->{
    Cell[9370, 284, 92, 1, 34, "Command",
      CellTags->{"OptionsDialog", "styleInspectorDialogID"}],
    Cell[9465, 287, 247, 6, 29, "Usage",
      CellTags->{"OptionsDialog", "styleInspectorDialogID"}],
    Cell[9715, 295, 679, 18, 22, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10409, 316, 384, 5, 50, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10796, 323, 85, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[10884, 326, 122, 1, 20, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11009, 329, 87, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11099, 332, 117, 1, 20, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11219, 335, 96, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11318, 338, 347, 6, 48, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11668, 346, 88, 1, 25, "DialogItem",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11759, 349, 155, 4, 20, "IndentedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[11917, 355, 198, 3, 22, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12118, 360, 157, 3, 22, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12278, 365, 189, 6, 22, "ItemizedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12470, 373, 171, 5, 22, "ItemizedText",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12644, 380, 203, 4, 38, "NotesList",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
    Cell[12850, 386, 472, 7, 64, "Notes",
      CellTags->{"styleInspectorDialogID", "OptionsDialog"}]},
  "ClearCellOptions"->{
    Cell[13347, 397, 65, 1, 34, "Command",
      CellTags->"ClearCellOptions"],
    Cell[13415, 400, 188, 5, 29, "Usage",
      CellTags->"ClearCellOptions"],
    Cell[13606, 407, 158, 3, 22, "Notes",
      CellTags->"ClearCellOptions"]},
  "MenuListFonts"->{
    Cell[13801, 415, 52, 1, 34, "Command",
      CellTags->"MenuListFonts"],
    Cell[13856, 418, 150, 3, 29, "Usage",
      CellTags->"MenuListFonts"],
    Cell[14009, 423, 334, 7, 56, "Notes",
      CellTags->"MenuListFonts"]},
  "NeXTFonts"->{
    Cell[14380, 435, 54, 1, 34, "Command",
      CellTags->"NeXTFonts"],
    Cell[14437, 438, 139, 3, 29, "Usage",
      CellTags->"NeXTFonts"]},
  "PlainFont"->{
    Cell[14613, 446, 48, 1, 34, "Command",
      CellTags->"PlainFont"],
    Cell[14664, 449, 157, 3, 29, "Usage",
      CellTags->"PlainFont"],
    Cell[14836, 455, 348, 11, 36, "Notes",
      CellTags->"PlainFont"]},
  "FontSize"->{
    Cell[15209, 470, 47, 1, 35, "Command",
      CellTags->"FontSize"],
    Cell[15259, 473, 165, 5, 32, "Usage",
      CellTags->"FontSize"],
    Cell[15439, 481, 215, 5, 25, "Notes",
      CellTags->"FontSize"]},
  "FontColor"->{
    Cell[15679, 490, 54, 1, 35, "Command",
      CellTags->"FontColor"],
    Cell[15736, 493, 167, 5, 32, "Usage",
      CellTags->"FontColor"],
    Cell[15918, 501, 217, 5, 25, "Notes",
      CellTags->"FontColor"]},
  "BackGround"->{
    Cell[16160, 510, 61, 1, 35, "Command",
      CellTags->"BackGround"],
    Cell[16224, 513, 176, 5, 32, "Usage",
      CellTags->"BackGround"],
    Cell[16403, 520, 458, 11, 65, "Notes",
      CellTags->"BackGround"],
    Cell[16864, 533, 167, 6, 25, "Notes",
      CellTags->"BackGround"]},
  "TextAlignment"->{
    Cell[17068, 544, 62, 1, 70, "Command",
      CellTags->"TextAlignment"],
    Cell[17133, 547, 184, 5, 70, "Usage",
      CellTags->"TextAlignment"],
    Cell[17320, 554, 558, 10, 70, "Notes",
      CellTags->"TextAlignment"]},
  "TextJustification"->{
    Cell[17915, 569, 70, 1, 70, "Command",
      CellTags->"TextJustification"],
    Cell[17988, 572, 193, 5, 70, "Usage",
      CellTags->"TextJustification"],
    Cell[18184, 579, 166, 3, 70, "Notes",
      CellTags->"TextJustification"],
    Cell[18353, 584, 300, 5, 70, "Notes",
      CellTags->"TextJustification"],
    Cell[18656, 591, 387, 7, 70, "Notes",
      CellTags->"TextJustification"]},
  "PageWidthDon't"->{
    Cell[19180, 609, 64, 1, 70, "Command",
      CellTags->"PageWidthDon't"],
    Cell[19247, 612, 152, 5, 70, "Usage",
      CellTags->"PageWidthDon't"],
    Cell[19414, 620, 197, 5, 70, "Notes",
      CellTags->"PageWidthDon't"]},
  "PageWidthPaper"->{
    Cell[19636, 629, 68, 1, 70, "Command",
      CellTags->"PageWidthPaper"],
    Cell[19707, 632, 230, 6, 70, "Usage",
      CellTags->"PageWidthPaper"],
    Cell[19952, 641, 324, 7, 70, "Notes",
      CellTags->"PageWidthPaper"]},
  "PageWidthWindow"->{
    Cell[20301, 652, 70, 1, 70, "Command",
      CellTags->"PageWidthWindow"],
    Cell[20374, 655, 193, 5, 70, "Usage",
      CellTags->"PageWidthWindow"],
    Cell[20582, 663, 333, 7, 70, "Notes",
      CellTags->"PageWidthWindow"]},
  "PageWidthFixed"->{
    Cell[20940, 674, 70, 1, 70, "Command",
      CellTags->"PageWidthFixed"],
    Cell[21013, 677, 246, 6, 70, "Usage",
      CellTags->"PageWidthFixed"],
    Cell[21274, 686, 272, 6, 70, "Notes",
      CellTags->"PageWidthFixed"]},
  "CellDingbat"->{
    Cell[21571, 696, 58, 1, 70, "Command",
      CellTags->"CellDingbat"],
    Cell[21632, 699, 207, 6, 70, "Usage",
      CellTags->"CellDingbat"],
    Cell[21854, 708, 303, 7, 70, "Notes",
      CellTags->"CellDingbat"]},
  "RulerBar"->{
    Cell[22182, 719, 53, 1, 70, "Command",
      CellTags->"RulerBar"],
    Cell[22238, 722, 180, 5, 70, "Usage",
      CellTags->"RulerBar"],
    Cell[22421, 729, 331, 7, 70, "Notes",
      CellTags->"RulerBar"]},
  "EditBar"->{
    Cell[22789, 741, 54, 1, 70, "Command",
      CellTags->"EditBar"],
    Cell[22846, 744, 207, 6, 70, "Usage",
      CellTags->"EditBar"],
    Cell[23056, 752, 477, 10, 70, "Notes",
      CellTags->"EditBar"]},
  "ShowPageBreaks"->{
    Cell[23570, 767, 65, 1, 70, "Command",
      CellTags->"ShowPageBreaks"],
    Cell[23638, 770, 175, 5, 70, "Usage",
      CellTags->"ShowPageBreaks"],
    Cell[23828, 778, 519, 13, 70, "Notes",
      CellTags->"ShowPageBreaks"]},
  "Magnification"->{
    Cell[24372, 795, 61, 1, 70, "Command",
      CellTags->"Magnification"],
    Cell[24436, 798, 178, 5, 70, "Usage",
      CellTags->"Magnification"],
    Cell[24629, 806, 432, 9, 70, "Notes",
      CellTags->"Magnification"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"MenuListStyles", 25808, 839},
  {"otherStyleNameDialogID", 26215, 850},
  {"MenuListScreenStyleEnvironments", 26339, 853},
  {"MenuListPrintingStyleEnvironments", 26661, 860},
  {"ToggleShowExpression", 26976, 867},
  {"MenuStyleSheet", 27331, 876},
  {"EditStyleDefinitions", 27743, 887},
  {"editingSharedStyleSheetID", 28594, 902},
  {"OptionsDialog", 29433, 917},
  {"styleInspectorDialogID", 31397, 954},
  {"ClearCellOptions", 33355, 991},
  {"MenuListFonts", 33615, 998},
  {"NeXTFonts", 33862, 1005},
  {"PlainFont", 34025, 1010},
  {"FontSize", 34260, 1017},
  {"FontColor", 34492, 1024},
  {"BackGround", 34728, 1031},
  {"TextAlignment", 35044, 1040},
  {"TextJustification", 35300, 1047},
  {"PageWidthDon't", 35724, 1058},
  {"PageWidthPaper", 35979, 1065},
  {"PageWidthWindow", 36235, 1072},
  {"PageWidthFixed", 36493, 1079},
  {"CellDingbat", 36745, 1086},
  {"RulerBar", 36985, 1093},
  {"EditBar", 37215, 1100},
  {"ShowPageBreaks", 37450, 1107},
  {"Magnification", 37705, 1114}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 54, 1, 34, "Command",
  CellTags->"MenuListStyles"],
Cell[1788, 54, 175, 5, 29, "Usage",
  CellTags->"MenuListStyles"],
Cell[1966, 61, 233, 6, 36, "Notes",
  CellTags->"MenuListStyles"],
Cell[2202, 69, 413, 9, 56, "Notes",
  CellTags->"MenuListStyles"],
Cell[2618, 80, 250, 9, 22, "Notes",
  CellTags->"MenuListStyles"],
Cell[2871, 91, 433, 10, 50, "Notes",
  CellTags->"otherStyleNameDialogID"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3341, 106, 90, 1, 34, "Command",
  CellTags->"MenuListScreenStyleEnvironments"],
Cell[3434, 109, 217, 5, 29, "Usage",
  CellTags->"MenuListScreenStyleEnvironments"],
Cell[3654, 116, 457, 9, 56, "Notes",
  CellTags->"MenuListScreenStyleEnvironments"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4148, 130, 94, 1, 34, "Command",
  CellTags->"MenuListPrintingStyleEnvironments"],
Cell[4245, 133, 213, 5, 29, "Usage",
  CellTags->"MenuListPrintingStyleEnvironments"],
Cell[4461, 140, 344, 7, 42, "Notes",
  CellTags->"MenuListPrintingStyleEnvironments"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4842, 152, 70, 1, 34, "Command",
  CellTags->"ToggleShowExpression"],
Cell[4915, 155, 190, 5, 29, "Usage",
  CellTags->"ToggleShowExpression"],
Cell[5108, 162, 719, 13, 104, "Notes",
  CellTags->"ToggleShowExpression"],
Cell[5830, 177, 658, 18, 22, "Notes",
  CellTags->"ToggleShowExpression"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6525, 200, 60, 1, 34, "Command",
  CellTags->"MenuStyleSheet"],
Cell[6588, 203, 184, 5, 29, "Usage",
  CellTags->"MenuStyleSheet"],
Cell[6775, 210, 182, 4, 22, "Notes",
  CellTags->"MenuStyleSheet"],
Cell[6960, 216, 429, 10, 50, "Notes",
  CellTags->"MenuStyleSheet"],
Cell[7392, 228, 377, 10, 42, "Notes",
  CellTags->"MenuStyleSheet"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7806, 243, 105, 1, 34, "Command",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[7914, 246, 227, 5, 29, "Usage",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[8144, 253, 389, 5, 56, "Notes",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[8536, 260, 150, 2, 25, "DialogItem",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[8689, 264, 268, 5, 34, "IndentedText",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[8960, 271, 154, 2, 25, "DialogItem",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}],
Cell[9117, 275, 216, 4, 20, "IndentedText",
  CellTags->{"EditStyleDefinitions", "editingSharedStyleSheetID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[9370, 284, 92, 1, 34, "Command",
  CellTags->{"OptionsDialog", "styleInspectorDialogID"}],
Cell[9465, 287, 247, 6, 29, "Usage",
  CellTags->{"OptionsDialog", "styleInspectorDialogID"}],
Cell[9715, 295, 679, 18, 22, "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}]
}, Open  ]],
Cell[10409, 316, 384, 5, 50, "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[10796, 323, 85, 1, 25, "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[10884, 326, 122, 1, 20, "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11009, 329, 87, 1, 25, "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11099, 332, 117, 1, 20, "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11219, 335, 96, 1, 25, "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11318, 338, 347, 6, 48, "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11668, 346, 88, 1, 25, "DialogItem",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11759, 349, 155, 4, 20, "IndentedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[11917, 355, 198, 3, 22, "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[12118, 360, 157, 3, 22, "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[12278, 365, 189, 6, 22, "ItemizedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[12470, 373, 171, 5, 22, "ItemizedText",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[12644, 380, 203, 4, 38, "NotesList",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],
Cell[12850, 386, 472, 7, 64, "Notes",
  CellTags->{"styleInspectorDialogID", "OptionsDialog"}],

Cell[CellGroupData[{
Cell[13347, 397, 65, 1, 34, "Command",
  CellTags->"ClearCellOptions"],
Cell[13415, 400, 188, 5, 29, "Usage",
  CellTags->"ClearCellOptions"],
Cell[13606, 407, 158, 3, 22, "Notes",
  CellTags->"ClearCellOptions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13801, 415, 52, 1, 34, "Command",
  CellTags->"MenuListFonts"],
Cell[13856, 418, 150, 3, 29, "Usage",
  CellTags->"MenuListFonts"],
Cell[14009, 423, 334, 7, 56, "Notes",
  CellTags->"MenuListFonts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14380, 435, 54, 1, 34, "Command",
  CellTags->"NeXTFonts"],
Cell[14437, 438, 139, 3, 29, "Usage",
  CellTags->"NeXTFonts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14613, 446, 48, 1, 34, "Command",
  CellTags->"PlainFont"],
Cell[14664, 449, 157, 3, 29, "Usage",
  CellTags->"PlainFont"]
}, Open  ]],
Cell[14836, 455, 348, 11, 36, "Notes",
  CellTags->"PlainFont"],

Cell[CellGroupData[{
Cell[15209, 470, 47, 1, 35, "Command",
  CellTags->"FontSize"],
Cell[15259, 473, 165, 5, 32, "Usage",
  CellTags->"FontSize"]
}, Open  ]],
Cell[15439, 481, 215, 5, 25, "Notes",
  CellTags->"FontSize"],

Cell[CellGroupData[{
Cell[15679, 490, 54, 1, 35, "Command",
  CellTags->"FontColor"],
Cell[15736, 493, 167, 5, 32, "Usage",
  CellTags->"FontColor"]
}, Open  ]],
Cell[15918, 501, 217, 5, 25, "Notes",
  CellTags->"FontColor"],

Cell[CellGroupData[{
Cell[16160, 510, 61, 1, 35, "Command",
  CellTags->"BackGround"],
Cell[16224, 513, 176, 5, 32, "Usage",
  CellTags->"BackGround"],
Cell[16403, 520, 458, 11, 65, "Notes",
  CellTags->"BackGround"],
Cell[16864, 533, 167, 6, 25, "Notes",
  CellTags->"BackGround"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17068, 544, 62, 1, 70, "Command",
  CellTags->"TextAlignment"],
Cell[17133, 547, 184, 5, 70, "Usage",
  CellTags->"TextAlignment"],
Cell[17320, 554, 558, 10, 70, "Notes",
  CellTags->"TextAlignment"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17915, 569, 70, 1, 70, "Command",
  CellTags->"TextJustification"],
Cell[17988, 572, 193, 5, 70, "Usage",
  CellTags->"TextJustification"],
Cell[18184, 579, 166, 3, 70, "Notes",
  CellTags->"TextJustification"],
Cell[18353, 584, 300, 5, 70, "Notes",
  CellTags->"TextJustification"],
Cell[18656, 591, 387, 7, 70, "Notes",
  CellTags->"TextJustification"]
}, Open  ]],
Cell[19058, 601, 97, 4, 70, "Section"],

Cell[CellGroupData[{
Cell[19180, 609, 64, 1, 70, "Command",
  CellTags->"PageWidthDon't"],
Cell[19247, 612, 152, 5, 70, "Usage",
  CellTags->"PageWidthDon't"]
}, Open  ]],
Cell[19414, 620, 197, 5, 70, "Notes",
  CellTags->"PageWidthDon't"],

Cell[CellGroupData[{
Cell[19636, 629, 68, 1, 70, "Command",
  CellTags->"PageWidthPaper"],
Cell[19707, 632, 230, 6, 70, "Usage",
  CellTags->"PageWidthPaper"]
}, Open  ]],
Cell[19952, 641, 324, 7, 70, "Notes",
  CellTags->"PageWidthPaper"],

Cell[CellGroupData[{
Cell[20301, 652, 70, 1, 70, "Command",
  CellTags->"PageWidthWindow"],
Cell[20374, 655, 193, 5, 70, "Usage",
  CellTags->"PageWidthWindow"]
}, Open  ]],
Cell[20582, 663, 333, 7, 70, "Notes",
  CellTags->"PageWidthWindow"],

Cell[CellGroupData[{
Cell[20940, 674, 70, 1, 70, "Command",
  CellTags->"PageWidthFixed"],
Cell[21013, 677, 246, 6, 70, "Usage",
  CellTags->"PageWidthFixed"]
}, Open  ]],
Cell[21274, 686, 272, 6, 70, "Notes",
  CellTags->"PageWidthFixed"],

Cell[CellGroupData[{
Cell[21571, 696, 58, 1, 70, "Command",
  CellTags->"CellDingbat"],
Cell[21632, 699, 207, 6, 70, "Usage",
  CellTags->"CellDingbat"]
}, Open  ]],
Cell[21854, 708, 303, 7, 70, "Notes",
  CellTags->"CellDingbat"],

Cell[CellGroupData[{
Cell[22182, 719, 53, 1, 70, "Command",
  CellTags->"RulerBar"],
Cell[22238, 722, 180, 5, 70, "Usage",
  CellTags->"RulerBar"],
Cell[22421, 729, 331, 7, 70, "Notes",
  CellTags->"RulerBar"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22789, 741, 54, 1, 70, "Command",
  CellTags->"EditBar"],
Cell[22846, 744, 207, 6, 70, "Usage",
  CellTags->"EditBar"],
Cell[23056, 752, 477, 10, 70, "Notes",
  CellTags->"EditBar"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23570, 767, 65, 1, 70, "Command",
  CellTags->"ShowPageBreaks"],
Cell[23638, 770, 175, 5, 70, "Usage",
  CellTags->"ShowPageBreaks"]
}, Open  ]],
Cell[23828, 778, 519, 13, 70, "Notes",
  CellTags->"ShowPageBreaks"],

Cell[CellGroupData[{
Cell[24372, 795, 61, 1, 70, "Command",
  CellTags->"Magnification"],
Cell[24436, 798, 178, 5, 70, "Usage",
  CellTags->"Magnification"]
}, Open  ]],
Cell[24629, 806, 432, 9, 70, "Notes",
  CellTags->"Magnification"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

